/**
 * Javascript to initialise the Recently accessed courses block.
 *
 * @module     block_recentlyaccessedcourses/main
 * @copyright  2018 Victor Deniz <victor@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("block_recentlyaccessedcourses/main",["jquery","core/custom_interaction_events","core/notification","core/pubsub","core/paged_content_paging_bar","core/templates","core_course/events","core_course/repository","core/aria"],(function($,CustomEvents,Notification,PubSub,PagedContentPagingBar,Templates,CourseEvents,CoursesRepository,Aria){var SELECTORS_BLOCK_CONTAINER='[data-region="recentlyaccessedcourses"]',SELECTORS_CARD_CONTAINER='[data-region="card-deck"]',SELECTORS_COURSE_IS_FAVOURITE='[data-region="is-favourite"]',SELECTORS_CONTENT='[data-region="view-content"]',SELECTORS_EMPTY_MESSAGE='[data-region="empty-message"]',SELECTORS_LOADING_PLACEHOLDER='[data-region="loading-placeholder"]',SELECTORS_PAGING_BAR='[data-region="paging-bar"]',SELECTORS_PAGING_BAR_NEXT='[data-control="next"]',SELECTORS_PAGING_BAR_PREVIOUS='[data-control="previous"]',contentLoaded=!1,allCourses=[],visibleCoursesId=null,cardWidth=null,viewIndex=0,availableVisibleCards=1,loadContent=function(userid){return CoursesRepository.getLastAccessedCourses(userid,10).then((function(courses){return function(courses){var showcoursecategory=$(SELECTORS_BLOCK_CONTAINER).data("displaycoursecategory"),promises=courses.map((function(course){return course.showcoursecategory=showcoursecategory,Templates.render("block_recentlyaccessedcourses/course-card",course)}));return $.when.apply(null,promises).then((function(){var renderedCourses=[];return promises.forEach((function(promise){promise.then((function(html){renderedCourses.push($(html))})).catch(Notification.exception)})),renderedCourses}))}(courses)}))},recalculateVisibleCourses=function(root){var container=root.find(SELECTORS_CONTENT).find(SELECTORS_CARD_CONTAINER),availableWidth=parseFloat(root.css("width")),numberOfCourses=allCourses.length,start=0;(cardWidth||(container.html(allCourses[0]),cardWidth=allCourses[0].outerWidth(!0)),availableVisibleCards=Math.floor(availableWidth/cardWidth),viewIndex+availableVisibleCards<numberOfCourses)?start=viewIndex:start=(start=viewIndex-(viewIndex+availableVisibleCards-numberOfCourses))>=0?start:0;0===availableVisibleCards&&(availableVisibleCards=1);var coursesToShow=allCourses.slice(start,start+availableVisibleCards),newVisibleCoursesId=coursesToShow.reduce((function(carry,course){return carry+course.attr("data-course-id")}),"");if(allCourses.length>coursesToShow.length?(container.addClass("justify-content-center"),container.removeClass("justify-content-start")):(container.removeClass("justify-content-center"),container.addClass("justify-content-start")),visibleCoursesId!=newVisibleCoursesId){var pagingBar=root.find(PagedContentPagingBar.rootSelector);container.html(coursesToShow),visibleCoursesId=newVisibleCoursesId,availableVisibleCards>=allCourses.length?function(root){var pagingBar=root.find(SELECTORS_PAGING_BAR);pagingBar.css("opacity",0),pagingBar.css("visibility","hidden"),Aria.hide(pagingBar)}(root):(!function(root){var pagingBar=root.find(SELECTORS_PAGING_BAR);pagingBar.css("opacity",1),pagingBar.css("visibility","visible"),Aria.unhide(pagingBar)}(root),0===viewIndex?PagedContentPagingBar.disablePreviousControlButtons(pagingBar):PagedContentPagingBar.enablePreviousControlButtons(pagingBar),viewIndex+availableVisibleCards>=allCourses.length?PagedContentPagingBar.disableNextControlButtons(pagingBar):PagedContentPagingBar.enableNextControlButtons(pagingBar))}},registerEventListeners=function(root){var resizeTimeout=null,drawerToggling=!1;PubSub.subscribe(CourseEvents.favourited,(function(courseId){!function(root,courseId){allCourses.forEach((function(course){course.attr("data-course-id")==courseId&&course.find(SELECTORS_COURSE_IS_FAVOURITE).removeClass("hidden")}))}(0,courseId)})),PubSub.subscribe(CourseEvents.unfavorited,(function(courseId){!function(root,courseId){allCourses.forEach((function(course){course.attr("data-course-id")==courseId&&course.find(SELECTORS_COURSE_IS_FAVOURITE).addClass("hidden")}))}(0,courseId)})),PubSub.subscribe("nav-drawer-toggle-start",(function(){if(contentLoaded&&allCourses.length&&!drawerToggling){drawerToggling=!0;var recalculationCount=0,doRecalculation=function(){setTimeout((function(){recalculateVisibleCourses(root),++recalculationCount<5&&drawerToggling&&doRecalculation()}),100)};doRecalculation(root)}})),PubSub.subscribe("nav-drawer-toggle-end",(function(){drawerToggling=!1})),$(window).on("resize",(function(){contentLoaded&&allCourses.length&&(resizeTimeout||(resizeTimeout=setTimeout((function(){resizeTimeout=null,recalculateVisibleCourses(root)}),66)))})),CustomEvents.define(root,[CustomEvents.events.activate]),root.on(CustomEvents.events.activate,SELECTORS_PAGING_BAR_NEXT,(function(e,data){$(e.target).closest(SELECTORS_PAGING_BAR_NEXT).hasClass("disabled")||(viewIndex+=availableVisibleCards,recalculateVisibleCourses(root)),data.originalEvent.preventDefault()})),root.on(CustomEvents.events.activate,SELECTORS_PAGING_BAR_PREVIOUS,(function(e,data){$(e.target).closest(SELECTORS_PAGING_BAR_PREVIOUS).hasClass("disabled")||(viewIndex=(viewIndex-=availableVisibleCards)<0?0:viewIndex,recalculateVisibleCourses(root)),data.originalEvent.preventDefault()}))};return{init:function(userid,root){root=$(root),registerEventListeners(root),loadContent(userid).then((function(renderedCourses){contentLoaded=!0,(allCourses=renderedCourses).length?(!function(root){root.find(SELECTORS_CONTENT).removeClass("hidden"),root.find(SELECTORS_EMPTY_MESSAGE).addClass("hidden"),root.find(SELECTORS_LOADING_PLACEHOLDER).addClass("hidden")}(root),recalculateVisibleCourses(root)):function(root){root.find(SELECTORS_EMPTY_MESSAGE).removeClass("hidden"),root.find(SELECTORS_LOADING_PLACEHOLDER).addClass("hidden"),root.find(SELECTORS_CONTENT).addClass("hidden")}(root)})).catch(Notification.exception)}}}));

//# sourceMappingURL=main.min.js.map